MODEL_PATH=$1
if [ -z "$2" ]; then
    overwrite=False
else
    overwrite=$2
fi

set -e # exit on error
image_folder="<DATA_FOLDER>"
DATASET="docci_complex_test.5k"
question_file="<DATA_FOLDER>docci/${DATASET}.eval.jsonl"
pred_file=${MODEL_PATH}/${DATASET}/merge.jsonl

MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
    echo "qwen-vl in model path"

else
    python_cmd="python -m llava.eval.model_vqa_loader --model-path ${MODEL_PATH} --question-file ${question_file} --image-folder ${image_folder} --answers-file ${pred_file} --temperature 0 --conv-mode vicuna_v1"

    # Append --overwrite if overwrite is True
    if [ "$overwrite" = "True" ]; then
        python_cmd="$python_cmd --overwrite"
    fi

    $python_cmd
    
    python_cmd="python -m llava.eval.get_vqa_pred_prob_only_yes_or_no --model-path ${MODEL_PATH} --question-file ${question_file} --pred-file ${pred_file} --image-folder ${image_folder} --answers-file ${MODEL_PATH}/${DATASET}/pred_probs_only_yes_or_no/merge.jsonl --temperature 0 --conv-mode vicuna_v1"

    # Append --overwrite if overwrite is True
    if [ "$overwrite" = "True" ]; then
        python_cmd="$python_cmd --overwrite"
    fi

    $python_cmd
fi


python llava/eval/lave_metric.py  plot_calibration_curve \
      --gt_data ${question_file} \
      --model_id models/Mistral/Mistral-7B-Instruct-v0.2 \
      --pred_data ${pred_file}  \
      --pred_prob_file ${MODEL_PATH}/${DATASET}/pred_probs_only_yes_or_no/merge.jsonl  

